/*----------------------------------------------------------------------------

NAME
	TabletControlsSample.cpp -- Win32 boilerplate and main entry point.

COPYRIGHT
	Copyright (c) Wacom Company, Ltd. 2014 All Rights Reserved
	All rights reserved.

	The text and information contained in this file may be freely used,
	copied, or distributed without compensation or licensing restrictions.

-----------------------------------------------------------------------------*/

#include "stdafx.h"
#include "resource.h"

#include "Drawing.h"
#include "Tablet.h"
//OLDC_CODE #include <Utils.h>
#include "Utils.h"
#include "TabletControlsSample.h"

#define MAX_LOADSTRING 100

char*	gpszProgramName = "Tablet Controls Sample";

////////////////////////////////////////////////////////////////////////////////
// Global Variables:
HINSTANCE	ghInst;									// current instance
TCHAR			gszTitle[MAX_LOADSTRING];			// The title bar text
TCHAR			gszWindowClass[MAX_LOADSTRING];	// the main window class name


////////////////////////////////////////////////////////////////////////////////
// Forward declarations
ATOM					MyRegisterClass(HINSTANCE hInstance);
BOOL					InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);



////////////////////////////////////////////////////////////////////////////////
// Main application entry point.
int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE, LPTSTR, int nCmdShow)
{
	MSG msg;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, gszTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_TABLETCONTROLSSAMPLE, gszWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance(hInstance, nCmdShow))
	{
		return FALSE;
	}

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (int)msg.wParam;
}



////////////////////////////////////////////////////////////////////////////////
// Wrapper to register window class.
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex = {0};

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style				= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc		= WndProc;
	wcex.hInstance			= hInstance;
	wcex.hIcon				= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_TABLETCONTROLSSAMPLE));
	wcex.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszClassName	= gszWindowClass;
	wcex.hIconSm			= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}



////////////////////////////////////////////////////////////////////////////////
// Initialize program state.
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	ghInst = hInstance; // Store instance handle in our global variable

	HWND hWnd = CreateWindow(gszWindowClass, gszTitle, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, 500, 400, NULL, NULL, hInstance, NULL);
	if (!hWnd)
	{
		return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}



////////////////////////////////////////////////////////////////////////////////
// Message handler for main window.
LRESULT CALLBACK WndProc(HWND hWnd_I, UINT message_I, WPARAM wParam_I, LPARAM lParam_I)
{
	//WACOM_TRACE("WndProc: msg: %i\n", message_I);

	switch (message_I)
	{
		case WM_CREATE:
			Tablet::Init(hWnd_I);
		break;

		case WM_SIZE:
			Drawing::Init(hWnd_I);
		break;

		case WM_PAINT:
		{
			PAINTSTRUCT ps = {0};
			HDC hdc = BeginPaint(hWnd_I, &ps);
			Drawing::PaintToHDC(hdc);
			EndPaint(hWnd_I, &ps);
		}
		break;

		case WT_PACKET:
		{
			PACKET pkt = {0};
			if (gpWTPacket((HCTX)lParam_I, (UINT)wParam_I, &pkt))
			{
				// This sample doesn't act on pen data
			}
		}
		break;

		case WT_PACKETEXT:
		{
			PACKETEXT pkt = {0};
			if (gpWTPacket((HCTX)lParam_I, (UINT)wParam_I, &pkt))
			{
				// Update display.
				Drawing::UpdateKeys(pkt.pkExpKeys.nTablet, pkt.pkExpKeys.nControl,
					pkt.pkExpKeys.nLocation, pkt.pkExpKeys.nState);
				Drawing::UpdateRing(pkt.pkTouchRing.nTablet, pkt.pkTouchRing.nControl,
					pkt.pkTouchRing.nMode, pkt.pkTouchRing.nPosition);
				Drawing::UpdateStrip(pkt.pkTouchStrip.nTablet, pkt.pkTouchStrip.nControl,
					pkt.pkTouchStrip.nMode, pkt.pkTouchStrip.nPosition);
				InvalidateRect(hWnd_I, NULL, TRUE);
			}
		}
		break;

		case WM_DESTROY:
			Drawing::Cleanup();
			Tablet::Cleanup();
			PostQuitMessage(0);
		break;

		default:
			return DefWindowProc(hWnd_I, message_I, wParam_I, lParam_I);
	}
	return 0;
}
