/*----------------------------------------------------------------------------

NAME
	Drawing.h -- Declarations of routines for drawing main display.

	COPYRIGHT
		Copyright (c) Wacom Company, Ltd. 2014 All Rights Reserved
		All rights reserved.

		The text and information contained in this file may be freely used,
		copied, or distributed without compensation or licensing restrictions.

-----------------------------------------------------------------------------*/

#pragma once

namespace Drawing
{
	void Init(HWND hWnd);
	void Cleanup();

	typedef void (*SetupControlPtr)(int, int, int, BOOL, int, int, int);

	void SetupKey(int tablet_I, int control_I, int function_I, BOOL availible_I,
		int location_I, int min_I, int max_I);

	void SetupRing(int tablet_I, int control_I, int function_I, BOOL availible_I,
		int location_I, int min_I, int max_I);

	void SetupStrip(int tablet_I, int control_I, int function_I, BOOL availible_I,
		int location_I, int min_I, int max_I);

	void UpdateKeys(int tablet_I, int control_I, int location_I, int state_I);
	void UpdateRing(int tablet_I, int control_I, int function_I, int position_I);
	void UpdateStrip(int tablet_I, int control_I, int function_I, int position_I);

	void PaintToHDC(HDC hdc_I);
}
