/*----------------------------------------------------------------------------

 FILE NAME
 OTouchableWindow.m

 PURPOSE
 A subclassed version of OHitRectMon which enables the receipt of finger or blob
 data into the window. This is where you methods would go to register your window
 and get touch data.

 COPYRIGHT
 Copyright WACOM Technology, Inc.  2014.
 All rights reserved.

 ----------------------------------------------------------------------------*/

#import "OTouchableWindow.h"
#import "FingerDataController.h"
@implementation OTouchableWindow

-(void) setFingerController:(id)controller
{
	mController = controller;
}


-(id) fingerController
{
	return mController;
}


/////////////////////////////////////////////////////////////////////////////
-(void) FingerDataAvailable:(WacomMTFingerCollection *)packet data:(void *)userData
{
#pragma unused(packet)
#pragma unused(userData)
//	NSLog(@"OTouchableWindow::FingerDataAvailable finger data came in");
	[(FingerDataController *)mController pushNewFingers:*packet];
	return;
}

@end
