/*----------------------------------------------------------------------------

FILE NAME
	FingerDataView.h

PURPOSE
	A view which displays finger data from the Wacom MultiTouch API.

COPYRIGHT
	Copyright WACOM Technology, Inc.  2011.
	All rights reserved.

----------------------------------------------------------------------------*/
#import <Cocoa/Cocoa.h>
#import <WacomMultiTouch/WacomMultiTouch.h>
#import "DisplayModes.h"


//////////////////////////////////////////////////////////////////////////////
@interface FingerDataView : NSView
{
	NSMutableArray *fingerData; // NSValues of pointers to WMTFingerCollections; a first-in, last-out queue
	NSSize         logicalSize; // tablet coordinate system extents
	
	NSUInteger     maxPacketsToDisplay;
	BOOL				clearOnNextDown;
	eDisplayMode   displayMode;
}

// Accessors
- (void) pushNewFingers:(WacomMTFingerCollection)fingerCollection;
- (void) setBoundsFromLogicalSize:(NSSize)deviceSize;

// Drawing
- (NSColor *) colorForFinger:(size_t)fingerIndex;

// Utilities
- (void) popAllFingers;

- (void) setDisplayMode:(eDisplayMode)mode;
@end
