/*----------------------------------------------------------------------------

FILE NAME
	FingerDataController.h

PURPOSE
	Displays finger data from callbacks from the Wacom MultiTouch API.

COPYRIGHT
	Copyright WACOM Technology, Inc.  2011.
	All rights reserved.

----------------------------------------------------------------------------*/
#import <Cocoa/Cocoa.h>
#import <WacomMultiTouch/WacomMultiTouch.h>
#import "OTouchableWindow.h"
#import "DisplayModes.h"
@class FingerDataView;
//////////////////////////////////////////////////////////////////////////////
@interface FingerDataController : NSObject
{
	IBOutlet OTouchableWindow       *window;
	IBOutlet FingerDataView *dataView;
	IBOutlet NSTextField		*fingerCountField;
	eDisplayMode displayMode;
	CGFloat  marginX;
	CGFloat  marginY;
	CGFloat	dataViewAspectRatio;
}

- (id) initWithDeviceID:(int)deviceID displayMode:(eDisplayMode)mode;

- (NSWindow *) window;
- (void) pushNewFingers:(WacomMTFingerCollection)fingerCollection;
- (void) setDisplayMode:(eDisplayMode)mode;
- (void) showWindow;

@end
