/*----------------------------------------------------------------------------

FILE NAME
	AppDelegate.h

PURPOSE
	Application controller for Wacom MultiTouch API sample application.

COPYRIGHT
	Copyright WACOM Technology, Inc.  2011.
	All rights reserved.

----------------------------------------------------------------------------*/
#import <Cocoa/Cocoa.h>
#import <WacomMultiTouch/WacomMultiTouch.h>

#import "DisplayModes.h"

//////////////////////////////////////////////////////////////////////////////
@interface AppDelegate : NSObject
{
	IBOutlet NSButton    *initButton;
	IBOutlet NSButton    *quitButton;
	IBOutlet NSButton    *fingerCallbackButton;
	IBOutlet	NSButton *RegisterWindowCallBacks;
	IBOutlet NSTableView *capabilitiesTable;
	
	NSMutableArray       *capabilitiesDataSource;	// used to display the capabilities table
	
	BOOL						isTouchAPIConnected;
	BOOL						isFingerCallbackRegistered;
	BOOL						isWindowCallbackRegistered;
	NSMutableDictionary	*fingerDataViewers;
	
	eDisplayMode         displayMode;
}

// Actions
- (IBAction) initializeTouchAPI:(id)sender;
- (IBAction) registerFingerCallback:(id)sender;
- (IBAction) quitTouchAPI:(id)sender;
- (IBAction)registerWindowCallback:(id)sender;

// Callbacks
- (void) deviceDidAttachWithCapabilities:(WacomMTCapability)capabilities;
- (void) deviceDidDetach:(int)deviceID;
- (void) didReceiveFingerData:(WacomMTFingerCollection)fingerPacket;

// Utilities
- (void) addFingerDataControllerForDeviceID:(int)deviceID;
- (void) displayAttachedDevices;
- (void) setConstraints;

@end

